


<?php $__env->startSection('title'); ?>
    <?php echo e(localize('Update Expert')); ?> <?php echo e(getSetting('title_separator')); ?> <?php echo e(getSetting('system_title')); ?>

<?php $__env->stopSection(); ?>


<?php $__env->startSection('contents'); ?>
    <section class="tt-section pt-4">
        <div class="container">

            <div class="row mb-4">
                <div class="col-12">
                    <div class="tt-page-header">
                        <div class="d-lg-flex align-items-center justify-content-lg-between">
                            <div class="tt-page-title mb-3 mb-lg-0">
                                <h1 class="h4 mb-lg-1"><?php echo e(localize('Update Expert')); ?></h1>
                                <ol class="breadcrumb breadcrumb-angle text-muted">
                                    <li class="breadcrumb-item"><a
                                            href="<?php echo e(route('writebot.dashboard')); ?>"><?php echo e(localize('Dashboard')); ?></a>
                                    </li>
                                    <li class="breadcrumb-item"><a
                                            href="<?php echo e(route('chat.experts')); ?>"><?php echo e(localize('Experts')); ?></a>
                                    </li>
                                    <li class="breadcrumb-item"><?php echo e(localize('Update Expert')); ?></li>
                                </ol>
                            </div>
                            <div class="tt-action">
                            </div>
                        </div>
                    </div>
                </div>
            </div>


            <div class="row mb-4 g-4">

                <!--left sidebar-->
                <div class="col-xl-9 order-2 order-md-2 order-lg-2 order-xl-1">
                    <form action="<?php echo e(route('chat.updateExpert')); ?>" method="POST" class="pb-650">
                        <?php echo csrf_field(); ?>
                        <input type="hidden" name="id" value="<?php echo e($expert->id); ?>">
                        <!--basic information start-->
                        <div class="card mb-4" id="section-1">
                            <div class="card-body">
                                <h5 class="mb-4"><?php echo e(localize('Basic Information')); ?></h5>

                                <div class="mb-4">
                                    <label for="name" class="form-label"><?php echo e(localize('Expert Name')); ?> <span
                                            class="text-danger">*</span> </label>
                                    <input type="text" name="name" id="name" value="<?php echo e($expert->name); ?>"
                                        placeholder="<?php echo e(localize('Type expert name')); ?>" class="form-control" required>
                                </div>

                                <div class="mb-4">
                                    <label for="short_name" class="form-label"><?php echo e(localize('Character Name')); ?> <span
                                            class="text-danger">*</span> </label>
                                    <input type="text" name="short_name" id="short_name"
                                        value="<?php echo e($expert->short_name); ?>"
                                        placeholder="<?php echo e(localize('Type character name')); ?>" class="form-control" required>
                                </div>

                                <div class="mb-4">
                                    <label class="form-label"><?php echo e(localize('Short Description')); ?></label>
                                    <textarea class="form-control" name="description" id="description" rows="4"
                                        placeholder="<?php echo e(localize('Type short description')); ?>"><?php echo e($expert->description); ?></textarea>
                                </div>


                                <div class="mb-4">
                                    <label for="role" class="form-label"><?php echo e(localize('Role')); ?> <span
                                            class="text-danger">*</span> </label>
                                    <input type="text" name="role" id="role" value="<?php echo e($expert->role); ?>"
                                        placeholder="<?php echo e(localize('Type role')); ?>" class="form-control" required>
                                </div>


                                <div class="mb-4">
                                    <label class="form-label"><?php echo e(localize('Expertise')); ?> <span
                                            class="text-danger">*</span> </label>
                                    <textarea class="form-control" name="assists_with" id="assists_with" rows="4"
                                        placeholder="<?php echo e(localize('I will assist you to generate better content')); ?>" required><?php echo e($expert->assists_with); ?></textarea>
                                </div>



                            </div>
                        </div>
                        <!--basic information end-->


                        <!--  chat training -->
                        <div class="card mb-4" id="section-train">
                            <div class="card-body">
                                <div class="d-flex align-items-center mb-4">
                                    <h5 class="me-3"><?php echo e(localize('Train Expert')); ?></h5>
                                    <a href="javascript:void(0);"
                                        class="btn btn-primary rounded-pill btn-sm py-2 chatTrainTestBtn">
                                        <?php echo e(localize('Generate Test Data')); ?></a>
                                </div>
                                <textarea class="form-control chat_training_data" name="chat_training_data" id="chat_training_data" rows="10"
                                    placeholder="Enter training data as json"><?php echo json_decode($expert->chat_training_data); ?></textarea>
                            </div>
                        </div>
                        <!-- chat training -->


                        <!-- image and gallery start-->
                        <div class="card mb-4" id="section-2">
                            <div class="card-body">
                                <h5 class="mb-4"><?php echo e(localize('Images')); ?></h5>
                                <div class="mb-4">
                                    <label class="form-label"><?php echo e(localize('Avatar Image')); ?> </label>
                                    <div class="tt-image-drop rounded">
                                        <span class="fw-semibold"><?php echo e(localize('Choose Avatar')); ?></span>
                                        <!-- choose media -->
                                        <div class="tt-product-thumb show-selected-files mt-3">
                                            <div class="avatar avatar-xl cursor-pointer choose-media"
                                                data-bs-toggle="offcanvas" data-bs-target="#offcanvasBottom"
                                                onclick="showMediaManager(this)" data-selection="single">
                                                <input type="hidden" name="image"
                                                    <?php if((int) $expert->avatar != 0): ?> value="<?php echo e($expert->avatar); ?>" <?php endif; ?>>
                                                <div class="no-avatar rounded-circle">
                                                    <span><i data-feather="plus"></i></span>
                                                </div>
                                            </div>
                                        </div>
                                        <!-- choose media -->
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!-- image and gallery end-->

                        <!-- submit button -->
                        <div class="row">
                            <div class="col-12">
                                <div class="mb-4">
                                    <button class="btn btn-primary" type="submit">
                                        <i data-feather="save" class="me-1"></i> <?php echo e(localize('Save Expert')); ?>

                                    </button>
                                </div>
                            </div>
                        </div>
                        <!-- submit button end -->

                    </form>
                </div>

                <!--right sidebar-->
                <div class="col-xl-3 order-1 order-md-1 order-lg-1 order-xl-2">
                    <div class="card tt-sticky-sidebar d-none d-xl-block">
                        <div class="card-body">
                            <h5 class="mb-4"><?php echo e(localize('Blog Information')); ?></h5>
                            <div class="tt-vertical-step">
                                <ul class="list-unstyled">
                                    <li>
                                        <a href="#section-1" class="active"><?php echo e(localize('Basic Information')); ?></a>
                                    </li>
                                    <li>
                                        <a href="#section-train"><?php echo e(localize('Train Expert')); ?></a>
                                    </li>
                                    <li>
                                        <a href="#section-2"><?php echo e(localize('Avatar')); ?></a>
                                    </li>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
    <script>
        "use strict";

        // runs when the document is ready --> for media files
        $(document).ready(function() {
            getChosenFilesCount();
            showSelectedFilePreviewOnLoad();
        });
    </script>

    <?php echo $__env->make('backend.pages.aiChat.inc.chat-scripts', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('backend.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\xampp\htdocs\ai\pinterai\resources\views/backend/pages/aiChat/experts/edit.blade.php ENDPATH**/ ?>