<div class="tt-single-template d-flex flex-column h-100 position-relative">
    <div
        class="card flex-column h-100 tt-template-card tt-corner-shape border-0 <?php if(Auth::check() && isCustomer() && !in_array($template->id, $subscriptionTemplates)): ?> tt-is-inactive <?php endif; ?>">

        <?php if(auth()->guard()->check()): ?>
            <?php
                $user = auth()->user();
            ?>
            <?php if(isCustomer()): ?>
                <?php if(!in_array($template->id, $subscriptionTemplates)): ?>
                    <span class="text-danger tt-inactive-plan" data-bs-toggle="tooltip" data-bs-placement="top"
                        data-bs-title="<?php echo e(localize('This template not included in your subscription plan')); ?>"><i
                            data-feather="info" class="icon-14"></i></span>
                <?php endif; ?>
            <?php endif; ?>
        <?php endif; ?>

        <a <?php if(Auth::check() && isCustomer() && !in_array($template->id, $subscriptionTemplates)): ?> href="javascript::void(0);" data-bs-toggle="tooltip" data-bs-placement="top"
            data-bs-title="<?php echo e(localize('This template is not included in your subscription plan')); ?>" <?php else: ?> href="<?php echo e(route('templates.show', $template->code)); ?>" <?php endif; ?>
            class="card-body d-flex flex-column h-100">
            <div class="tt-card-info mb-4">
                <div class="tt-template-icon mb-3">
                    <?php if($template->icon == null): ?>
                        <img src="<?php echo e(staticAsset('backend/assets/img/templates/' . $template->code . '.png')); ?>"
                            alt="" class="img-fluid">
                    <?php else: ?>
                        <img src="<?php echo e(uploadedAsset($template->icon)); ?>" alt="" class="img-fluid">
                    <?php endif; ?>
                </div>
                <h3 class="h6"><?php echo e($template->collectLocalization('name')); ?></h3>
                <p class="mb-0"><?php echo e($template->collectLocalization('description') ?? ''); ?>

                </p>
            </div>
            <div class="mt-auto">
                <div class="d-flex align-items-center justify-content-between">
                    <span class="fs-md text-muted d-block">
                        <?php if(auth()->guard()->check()): ?>
                            <?php if(auth()->user()->user_type != 'customer'): ?>
                                <?php echo e(formatWords($template->total_words_generated)); ?>

                            <?php else: ?>
                                <?php echo e(formatWords($template->templateUsage()->where('user_id', auth()->user()->id)->sum('total_used_words'))); ?>

                            <?php endif; ?>
                            <?php echo e(localize('Words Generated')); ?>


                        <?php endif; ?>
                        <?php if(auth()->guard()->guest()): ?>
                            <?php echo e(formatWords($template->total_words_generated)); ?>

                            <?php echo e(localize('Words Generated')); ?>

                        <?php endif; ?>
                    </span>
                </div>
            </div>
        </a>

        <div class="d-flex align-items-center justify-content-end template-actions">
            <?php if(auth()->guard()->check()): ?>
                <button
                    class="border-0 bg-transparent tt-template-edit position-absolute d-flex align-items-center favorite-template"
                    data-bs-toggle="tooltip" data-bs-placement="top" data-bs-title="<?php echo e(localize('Favorite')); ?>"
                    data-template="<?php echo e($template->id); ?>">
                    <i
                        class="<?php echo e(in_array($template->id, $favoritesArray) ? 'las' : 'lar'); ?>  la-heart fs-lg <?php echo e(in_array($template->id, $favoritesArray) ? 'text-success' : ''); ?>"></i>
                </button>

                <?php if(auth()->user()->user_type != 'customer'): ?>
                    <a href="<?php echo e(route('templates.edit', ['id' => $template->id, 'lang_key' => env('DEFAULT_LANGUAGE')])); ?>&localize"
                        class="border-0 px-1 bg-transparent tt-template-edit position-absolute d-flex align-items-center edit-template"
                        data-bs-toggle="tooltip" data-bs-placement="top" data-bs-title="<?php echo e(localize('Edit')); ?>">
                        <i data-feather="edit-3" class="icon-14 text-primary"></i>
                    </a>

                    <a href="javascript:void(0);"
                        class="border-0 px-1 bg-transparent tt-template-edit position-absolute d-flex align-items-center delete-template"
                        data-bs-toggle="tooltip" data-bs-placement="top" data-bs-title="<?php echo e(localize('Delete')); ?>"
                        data-template="<?php echo e($template->id); ?>" data-href="<?php echo e(route('templates.delete', $template->id)); ?>"
                        onclick="confirmDelete(this)">
                        <i data-feather="trash" class="icon-14 text-danger"></i>
                    </a>
                <?php endif; ?>
            <?php endif; ?>
            <?php if(auth()->guard()->guest()): ?>
                <a class="border-0 bg-transparent tt-template-edit position-absolute d-flex align-items-center"
                    href="<?php echo e(route('login')); ?>">
                    <i class="lar la-heart fs-lg"></i>
                </a>
            <?php endif; ?>
        </div>
    </div>
</div>
<?php /**PATH E:\xampp\htdocs\ai\pinterai\resources\views/backend/pages/templates/inc/template-card.blade.php ENDPATH**/ ?>