

<?php $__env->startSection('title'); ?>
    <?php echo e(localize('AI Chat Experts')); ?> <?php echo e(getSetting('title_separator')); ?> <?php echo e(getSetting('system_title')); ?>

<?php $__env->stopSection(); ?>


<?php $__env->startSection('contents'); ?>
    <section class="tt-section pt-4">
        <div class="container">
            <div class="row mb-4">
                <div class="col-12">
                    <div class="tt-page-header">
                        <div class="d-lg-flex align-items-center justify-content-lg-between">
                            <div class="tt-page-title mb-3 mb-lg-0">
                                <h1 class="h4 mb-lg-1"><?php echo e(localize('AI Chat Experts')); ?></h1>
                                <ol class="breadcrumb breadcrumb-angle text-muted">
                                    <li class="breadcrumb-item"><a
                                            href="<?php echo e(route('writebot.dashboard')); ?>"><?php echo e(localize('Dashboard')); ?></a>
                                    </li>
                                    <li class="breadcrumb-item"><?php echo e(localize('AI Chat Experts')); ?></li>
                                </ol>
                            </div>
                            <div class="tt-action d-flex">
                                <?php if(auth()->user()->user_type != "customer"): ?>
                                <a href="<?php echo e(route('chat.prompts')); ?>" class="btn btn-sm btn-success me-2" target="__blank"><i
                                    data-feather="plus"></i> <?php echo e(localize('Add Chat Prompts')); ?></a>
                                    <a href="<?php echo e(route('chat.createExpert')); ?>" class="btn btn-sm btn-primary"><i
                                        data-feather="plus"></i> <?php echo e(localize('Add Chat Expert')); ?></a>
                                        
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="row g-3">
                <div class="col-12">
                    <div class="card flex-column h-100">
                        <div class="card-header p-3 p-md-4 p-lg-5">
                            <div class="row justify-content-center align-items-center">
                                <div class="col-lg-8 col-md-9 col-12">
                                    <!-- image generate form -->
                                    <form action="" class="header-search-form">
                                        <!-- image generate form -->
                                        <div class="input-group">
                                            <input type="search" name="search"
                                                placeholder="<?php echo e(localize('Search expertise you are looking for')); ?>..."
                                                class="form-control border border-2 border-primary rounded-pill rounded-end"
                                                <?php if(isset($searchKey)): ?>
                                                value="<?php echo e($searchKey); ?>"
                                                <?php endif; ?>>
                                            <div class="input-group-append">
                                                <button type="submit"
                                                    class="btn btn-link bg-primary border border-2 border-primary text-light rounded-pill rounded-start"><i
                                                        class="flaticon-search translate-middle-y"></i><?php echo e(localize('Search Experts')); ?></button>
                                                        
                                                    
                                            </div>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                        <div class="card-body d-flex flex-column h-100">
                            <div class="row g-3">

                                <?php $__currentLoopData = $chatExperts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $expert): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php
                                        $url = route('chat.index') .'?expert='.$expert->id;
                                        if($expert->type == 'vision'){
                                            $url = route('vision.index');
                                        }elseif($expert->type == 'image'){
                                            $url = route('imageChat.index');
                                        }elseif($expert->type == 'pdf'){
                                            $url = route('pdfChat.index');
                                        }
                                    ?>
                                    <div class="col-lg-3 col-md-6">
                                        <div class="tt-single-expert  p-3 rounded-3">
                                            <a href="<?php echo e($url); ?>"
                                                class="d-flex align-content-center">
                                                <div class="avatar avatar-md">
                                                    <?php if($expert->avatar == null): ?>
                                                    <img class="rounded-circle" src="<?php echo e(staticAsset('/backend/assets/img/avatar/1.jpg')); ?>"
                                                    alt="avatar" />
                                                    <?php else: ?>
                                                    <img class="rounded-circle" src="<?php echo e((int)$expert->avatar == 0 ? staticAsset($expert->avatar) : uploadedAsset($expert->avatar)); ?>"
                                                    alt="avatar" />
                                                    <?php endif; ?>
                                                    
                                                </div>
                                                <div class="tt-expert-info ms-2">
                                                    <h6 class="mb-0"><?php echo e($expert->name); ?></h6>
                                                    <p class="text-muted mb-0 small text-capitalize"><?php echo e($expert->role); ?>

                                                    </p>
                                                </div>
                                            </a>
                                            <?php if(auth()->user()->user_type != "customer"): ?>
                                                <div class="tt-expert-chat position-absolute">
                                                    <div class="d-flex align-items-center">
                                                        <div class="d-flex align-items-center"> 
                                                            <div class="form-check form-switch me-2">
                                                                <input type="checkbox" class="form-check-input cursor-pointer tt_editable" onchange="updateChat(<?php echo e($expert->id); ?>)"
                                                                    id="is_active-<?php echo e($expert->id); ?>" data-name="is_active-<?php echo e($expert->id); ?>"
                                                                <?php if($expert->is_active == 1): ?>
                                                                    checked
                                                                <?php endif; ?>    
                                                                >
                                                            </div> 
                                                        </div>  

                                                        <a href="<?php echo e(route('chat.editExpert', $expert->slug)); ?>">
                                                            <span>
                                                                <i data-feather="edit-3" class="icon-16"></i>
                                                            </span>
                                                        </a> 
                                                    </div>  
                                                </div>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>


        </div>
    </section>
<?php $__env->stopSection(); ?>


<?php $__env->startSection('scripts'); ?>
    <?php echo $__env->make('backend.pages.aiChat.inc.chat-scripts', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <script>
        "use strict";

        // update chat
        function updateChat(id) {
            let result = $.ajax({
                headers: {
                    'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>'
                },
                method: 'POST',
                url: '<?php echo e(route('chat.updateStatus')); ?>',
                data: {
                    id:id
                },
                success: function(response) {
                    notifyMe('success', '<?php echo e(localize('Status updated successfully')); ?>');

                },
                error: function(data) {
                    notifyMe('error', '<?php echo e(localize('Something went wrong')); ?>');
                }
            }); 
        }
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('backend.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\xampp\htdocs\ai\pinterai\resources\views/backend/pages/aiChat/experts.blade.php ENDPATH**/ ?>