

<?php $__env->startSection('title'); ?>
    <?php echo e(localize('Auth Settings')); ?> <?php echo e(getSetting('title_separator')); ?> <?php echo e(getSetting('system_title')); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('contents'); ?>
    <section class="tt-section pt-4">
        <div class="container">


            <div class="row mb-4">
                <div class="col-12">
                    <div class="tt-page-header">
                        <div class="d-lg-flex align-items-center justify-content-lg-between">
                            <div class="tt-page-title mb-3 mb-lg-0">
                                <h1 class="h4 mb-lg-1"><?php echo e(localize('Auth Settings')); ?></h1>
                                <ol class="breadcrumb breadcrumb-angle text-muted">
                                    <li class="breadcrumb-item"><a
                                            href="<?php echo e(route('writebot.dashboard')); ?>"><?php echo e(localize('Dashboard')); ?></a>
                                    </li>
                                    <li class="breadcrumb-item"><?php echo e(localize('Auth Settings')); ?></li>
                                </ol>
                            </div>
                            <div class="tt-action">
                                <?php if (isset($component)) { $__componentOriginal3a0007b8d43940d96038815b29fa2d03631850fa = $component; } ?>
<?php $component = App\View\Components\ChangeLanguage::resolve(['langkey' => $lang_key] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('change-language'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(App\View\Components\ChangeLanguage::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal3a0007b8d43940d96038815b29fa2d03631850fa)): ?>
<?php $component = $__componentOriginal3a0007b8d43940d96038815b29fa2d03631850fa; ?>
<?php unset($__componentOriginal3a0007b8d43940d96038815b29fa2d03631850fa); ?>
<?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>


            <div class="row g-4">
                <!--left sidebar-->
                <div class="col-xl-9 order-2 order-md-2 order-lg-2 order-xl-1">
                    <form action="<?php echo e(route('admin.settings.update')); ?>" method="POST" enctype="multipart/form-data"
                        class="pb-650">
                        <?php echo csrf_field(); ?>
                        <input type="hidden" name="language_key" id="language_id" value="<?php echo e($lang_key); ?>">
                        <!--login settings-->
                        <div class="card mb-4" id="section-1">
                            <div class="card-body">
                                <h5 class="mb-4"><?php echo e(localize('Login & Registration')); ?></h5>
                                <?php if(checkLanguage($lang_key)): ?>
                                    <div class="mb-3">
                                        <label for="registration_with"
                                            class="form-label"><?php echo e(localize('Customer Registration')); ?></label>
                                        <input type="hidden" name="types[]" value="registration_with">
                                        <select id="registration_with" class="form-control text-uppercase select2"
                                            name="registration_with" data-toggle="select2">
                                            <option value="email"
                                                <?php echo e(getSetting('registration_with') == 'email' ? 'selected' : ''); ?>>
                                                <?php echo e(localize('Email Required')); ?></option>
                                            <option value="email_and_phone"
                                                <?php echo e(getSetting('registration_with') == 'email_and_phone' ? 'selected' : ''); ?>>
                                                <?php echo e(localize('Email & Phone Both Required')); ?></option>
                                        </select>
                                    </div>

                                    <div class="mb-3">
                                        <label for="registration_verification_with"
                                            class="form-label"><?php echo e(localize('Registration Verification')); ?></label>
                                        <input type="hidden" name="types[]" value="registration_verification_with">
                                        <select id="registration_verification_with"
                                            class="form-control text-uppercase select2"
                                            name="registration_verification_with" data-toggle="select2">
                                            <option value="disable"
                                                <?php echo e(getSetting('registration_verification_with') == 'disable' ? 'selected' : ''); ?>>
                                                <?php echo e(localize('Disable')); ?></option>
                                            <option value="email"
                                                <?php echo e(getSetting('registration_verification_with') == 'email' ? 'selected' : ''); ?>>
                                                <?php echo e(localize('Email Verification')); ?></option>
                                            <option value="phone"
                                                <?php echo e(getSetting('registration_verification_with') == 'phone' ? 'selected' : ''); ?>>
                                                <?php echo e(localize('OTP Verification')); ?></option>
                                        </select>
                                    </div>


                                    <div class="mb-3">
                                        <label for="welcome_email"
                                            class="form-label"><?php echo e(localize('Send Welcome Email After Registration')); ?></label>
                                        <input type="hidden" name="types[]" value="welcome_email">
                                        <select id="welcome_email" class="form-control text-uppercase select2"
                                            name="welcome_email" data-toggle="select2">
                                            <option value="0"
                                                <?php echo e(getSetting('welcome_email') == 0 ? 'selected' : ''); ?>>
                                                <?php echo e(localize('Disable')); ?></option>
                                            <option value="1"
                                                <?php echo e(getSetting('welcome_email') == 1 ? 'selected' : ''); ?>>
                                                <?php echo e(localize('Enable')); ?></option>

                                        </select>
                                    </div>
                                <?php endif; ?>
                                <div class="mb-3">
                                    <label for="login_leftbar_title"
                                        class="form-label"><?php echo e(localize('Leftbar Title')); ?></label>
                                    <input type="hidden" name="types[]" value="login_leftbar_title">
                                    <input type="text" id="login_leftbar_title" name="login_leftbar_title"
                                        class="form-control"
                                        value="<?php echo e(systemSettingsLocalization('login_leftbar_title', $lang_key)); ?>">
                                </div>

                                <div class="mb-3">
                                    <label for="login_leftbar_colored_title"
                                        class="form-label"><?php echo e(localize('Leftbar Colored Title')); ?></label>
                                    <input type="hidden" name="types[]" value="login_leftbar_colored_title">
                                    <input type="text" id="login_leftbar_colored_title"
                                        name="login_leftbar_colored_title" class="form-control"
                                        value="<?php echo e(systemSettingsLocalization('login_leftbar_colored_title', $lang_key)); ?>">
                                </div>

                                <div class="mb-3">
                                    <label for="login_rightbar_title"
                                        class="form-label"><?php echo e(localize('Rightbar Title')); ?></label>
                                    <input type="hidden" name="types[]" value="login_rightbar_title">
                                    <input type="text" id="login_rightbar_title" name="login_rightbar_title"
                                        class="form-control"
                                        value="<?php echo e(systemSettingsLocalization('login_rightbar_title', $lang_key)); ?>">
                                </div>

                                <div class="mb-3">
                                    <label for="login_rightbar_sub_title"
                                        class="form-label"><?php echo e(localize('Rightbar Subtitle')); ?></label>
                                    <input type="hidden" name="types[]" value="login_rightbar_sub_title">
                                    <input type="text" id="login_rightbar_sub_title" name="login_rightbar_sub_title"
                                        class="form-control"
                                        value="<?php echo e(systemSettingsLocalization('login_rightbar_sub_title', $lang_key)); ?>">
                                </div>

                            </div>
                        </div>
                        <!--login settings-->
                        <?php if(checkLanguage($lang_key)): ?>
                            <!--recaptcha settings-->
                            <div class="card mb-4" id="section-2">
                                <div class="card-body">
                                    <h5 class="mb-4"><?php echo e(localize('Google Recaptcha V3')); ?></h5>


                                    <div class="mb-3">
                                        <label for="RECAPTCHAV3_SITEKEY"
                                            class="form-label"><?php echo e(localize('Recaptcha Site Key')); ?></label>
                                        <input type="hidden" name="types[]" value="RECAPTCHAV3_SITEKEY">
                                        <input type="text" id="RECAPTCHAV3_SITEKEY" name="RECAPTCHAV3_SITEKEY"
                                            class="form-control" value="<?php echo e(env('RECAPTCHAV3_SITEKEY')); ?>">
                                    </div>


                                    <div class="mb-3">
                                        <label for="RECAPTCHAV3_SECRET"
                                            class="form-label"><?php echo e(localize('Recaptcha Secret Key')); ?></label>
                                        <input type="hidden" name="types[]" value="RECAPTCHAV3_SECRET">
                                        <input type="text" id="RECAPTCHAV3_SECRET" name="RECAPTCHAV3_SECRET"
                                            class="form-control" value="<?php echo e(env('RECAPTCHAV3_SECRET')); ?>">
                                    </div>


                                    <div class="mb-3">
                                        <label for="enable_recaptcha"
                                            class="form-label"><?php echo e(localize('Enable Recaptcha')); ?></label>
                                        <input type="hidden" name="types[]" value="enable_recaptcha">
                                        <select id="enable_recaptcha" class="form-control text-uppercase select2"
                                            name="enable_recaptcha" data-toggle="select2">
                                            <option value="1"
                                                <?php echo e(getSetting('enable_recaptcha') == 1 ? 'selected' : ''); ?>>
                                                <?php echo e(localize('Enable')); ?></option>
                                            <option value="0"
                                                <?php echo e(getSetting('enable_recaptcha') == 0 ? 'selected' : ''); ?>>
                                                <?php echo e(localize('Disable')); ?></option>
                                        </select>
                                    </div>

                                </div>
                            </div>
                            <!--recaptcha settings-->
                        <?php endif; ?>
                        <div class="mb-3">
                            <button class="btn btn-primary" type="submit">
                                <i data-feather="save" class="me-1"></i> <?php echo e(localize('Save Configuration')); ?>

                            </button>
                        </div>
                    </form>
                </div>

                <!--right sidebar-->
                <div class="col-xl-3 order-1 order-md-1 order-lg-1 order-xl-2">
                    <div class="card tt-sticky-sidebar">
                        <div class="card-body">
                            <h5 class="mb-4"><?php echo e(localize('Configure General Settings')); ?></h5>
                            <div class="tt-vertical-step">
                                <ul class="list-unstyled">
                                    <li>
                                        <a href="#section-1" class="active"><?php echo e(localize('Login & Registration')); ?></a>
                                    </li>
                                    <li>
                                        <a href="#section-2" class=""><?php echo e(localize('Google Recaptcha')); ?></a>
                                    </li>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
    <script>
        "use strict";

        // runs when the document is ready --> for media files
        $(document).ready(function() {
            getChosenFilesCount();
            showSelectedFilePreviewOnLoad();
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('backend.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\xampp\htdocs\ai\pinterai\resources\views/backend/pages/systemSettings/authSettings.blade.php ENDPATH**/ ?>