<!DOCTYPE html>

<?php
    
    $locale = str_replace('', '-', app()->getLocale());
    $localLang = \App\Models\Language::where('code', $locale)->first();
    if ($localLang == null) {
        $localLang = \App\Models\Language::where('code', 'en')->first();
    }
?>

<?php if($localLang->is_rtl == 1): ?>
    <html dir="rtl" lang="<?php echo e($locale); ?>" data-bs-theme="<?php echo e(getSetting('theme_mode') ?? "light"); ?>">
<?php else: ?>
    <html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>" data-bs-theme="<?php echo e(getSetting('theme_mode') ?? "light"); ?>">
<?php endif; ?>


<head>
    <!--required meta tags-->
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

    <!--favicon icon-->
    <link rel="icon" href="<?php echo e(uploadedAsset(getSetting('favicon'))); ?>" type="image/png" sizes="16x16">

    <!--title-->
    <title>
        <?php echo $__env->yieldContent('title'); ?>
    </title>

    <?php if(env('ENABLE_GOOGLE_ANALYTICS') == 1): ?>
        <!-- Global site tag (gtag.js) - Google Analytics -->
        <script async src="https://www.googletagmanager.com/gtag/js?id=<?php echo e(env('TRACKING_ID')); ?>"></script>

        <script>
            window.dataLayer = window.dataLayer || [];

            function gtag() {
                dataLayer.push(arguments);
            }
            gtag('js', new Date());
            gtag('config', '<?php echo e(env('TRACKING_ID')); ?>');
        </script>
    <?php endif; ?>

    <!--build:css-->
    <?php echo $__env->make('frontend.default.inc.css', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <!-- endbuild -->
    
    <!-- recaptcha -->
    <?php if(getSetting('enable_recaptcha') == 1): ?>
        <?php echo RecaptchaV3::initJs(); ?>

    <?php endif; ?>
    <!-- recaptcha -->


    <?php
        echo getSetting('header_custom_css');
    ?>

    <?php
        echo '<script>'.getSetting('header_custom_scripts').'</script>';
    ?>
</head>

<body>

    <!--preloader start-->
    <?php if(getSetting('enable_preloader') != '0'): ?>
        <div id="preloader" class="bg-light-subtle">
            <div class="preloader-wrap">
                <img src="<?php echo e(uploadedAsset(getSetting('navbar_logo_dark'))); ?>" class="img-fluid">
                <div class="loading-bar"></div>
            </div>
        </div>
    <?php endif; ?>
    <!--preloader end-->

    <!--main content wrapper start-->
    <main class="tt-main-wrapper position-relative z-1">

        <?php echo $__env->yieldContent('contents'); ?>

    </main>

    <!-- scripts -->
    <?php echo $__env->yieldContent('scripts'); ?>

    <!--build:js-->
    <?php echo $__env->make('frontend.default.inc.scripts', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <!--endbuild-->
</body>

</html>
<?php /**PATH E:\xampp\htdocs\ai\pinterai\resources\views/layouts/auth.blade.php ENDPATH**/ ?>