

<?php $__env->startSection('title'); ?>
    <?php echo e(localize('AI PDF Chat')); ?> <?php echo e(getSetting('title_separator')); ?> <?php echo e(getSetting('system_title')); ?>

<?php $__env->stopSection(); ?>


<?php $__env->startSection('contents'); ?>
    <section class="tt-section pt-4">
        <div class="container">

            <div class="row mb-4">
                <div class="col-12">
                    <div class="tt-page-header">
                        <div class="d-flex flex-wrap align-items-center justify-content-between">
                            <div class="tt-page-title mb-3 mb-lg-0">
                                <h1 class="h4 mb-lg-1"><?php echo e(localize('AI PDF Chat')); ?></h1>
                                <ol class="breadcrumb breadcrumb-angle text-muted">
                                    <li class="breadcrumb-item"><a href="#">  <?php echo e(localize('Home')); ?> </a></li>
                                    <li class="breadcrumb-item"><?php echo e(localize('AI PDF Chat')); ?></li>
                                </ol>
                            </div>
                        </div>

                        <div class="d-block d-lg-none mt-3">

                            <button
                                class="form-label tt-advance-options cursor-pointer mb-0 btn btn-light shadow-sm btn-sm rounded-pill">
                                <span class="fw-bold tt-promot-number fw-bold me-1"></span>
                                <?php echo e(localize('Show History')); ?>

                                <span>
                                    <i data-feather="plus" class="icon-16 text-primary ms-2"></i>
                                </span>
                            </button>

                            <div id="tt-advance-options">
                                <?php echo $__env->make("backend.pages.pdfChat.pdfChatLeftSidebar", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                            </div>
                        </div>

                    </div>
                </div>
            </div>

            <div class="row mb-5">
                <div class="col-xl-12">
                    <div class="card">
                        <div class="card-body p-0">
                            <div id="tt-ai-chat" class="d-flex" style="height: 65vh;">
                                <!-- chat right box start -->
                                <div class="tt-chat-right d-flex w-100">
                                    <?php echo $__env->make("backend.pages.pdfChat.pdfChatLeftSidebar", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

                                    <div class="w-100 d-flex flex-column">
                                        <?php echo $__env->make("backend.pages.pdfChat.chat-top", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

                                        <!-- chat conversation start -->
                                        <div class="tt-conversation p-4 tt-custom-scrollbar convo123">
                                            <?php echo $__env->make("backend.pages.pdfChat.pdf-chat-conversations", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                        </div>

                                        <?php echo $__env->make("backend.pages.pdfChat.form-pdf", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                    </div>

                                    <!-- for preloader -->
                                    <div class="tt-chat-right d-flex w-100 d-none">
                                        <div class="tt-content-placeholder bg-secondary-subtle">
                                            <div class="tt-preloader-wrap">
                                                <span class="tt-preloader-bar"></span>
                                            </div>
                                        </div>
                                    </div>
                                    <!-- chat right box end -->
                                </div>
                                <!-- chat right box end -->

                                <!-- chat right with preloader start -->
                                <div class="tt-chat-right d-flex w-100 d-none">
                                    <!-- text preloader start -->
                                    <div class="tt-text-preloader tt-preloader-center">
                                        <span></span>
                                        <span></span>
                                        <span></span>
                                    </div>
                                    <!-- text preloader end -->
                                </div>
                                <!-- chat right with preloader end -->
                            </div>
                        </div>
                    </div>
                </div>

                
                <?php echo $__env->make("backend.pages.pdfChat.pdf-chat-delete", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

            </div>
        </div>
    </section>
<?php $__env->stopSection(); ?>


<?php $__env->startSection('scripts'); ?>

    <script>
        "use strict";

        // show hide templates optional field
        $("#tt-advance-options").hide();
        $(".tt-advance-options").on("click", function(e) {
            $("#tt-advance-options").slideToggle(300);
        });

        let basePath = "<?php echo e(url('/')); ?>";
        let messageContainer = $(".convo123");
        let loaderMessage = $(".mrLoader");
        let outputDiv = $('.convo123');
        let sentence = '';

        $(()=>{
            initScrollToChatBottom();
        });

        $("#pdf-delete-modal").on("hidden.bs.modal", function () {
            $(".erase").attr("data-id", null);
        });

        $(".pdfNewChat").click(async function () {

            $('#vision_image').html(null);

            await $.ajax({
               "url": "<?php echo e(route('pdfChat.index')); ?>?newChat=true",
               "type": "GET",
               "success": function (response) {
                   console.log("Success  is : ",response);
                   $(".pdfChatLi").html(null);

                   $(".pdfChatLi").html(response.data);

                   $(".convo123").html("");

                   initFeather();
               },
               "error": function (XHR, textStatus, errorThrown) {
                   console.log("Error is : ",XHR);
               }
            });
        })

        function deleteModalShow(id){
            $("#pdf-delete-modal").modal("show");
            $(".erase").attr("data-id",id);
        }

        $(document).on("click", ".erase", function () {
            console.log("Clicked on Erase Button.");
            let id = $(this).attr("data-id");
           deletePdfChat(id);
        });

        async function deletePdfChat(id){

            $('#vision_image').html(null);

            await $.ajax({
                "type": "POST",
                "url": "<?php echo e(route('pdfChat.destroy')); ?>",
                "data" : {
                    _token : "<?php echo e(csrf_token()); ?>",
                    pdf_chat_id : id
                },
                "success": function (response) {
                    console.log("Delete Success  is : ",response);
                    $(".pdfChatLi").html(response.data);
                    $("#pdf-delete-modal").modal("hide");
                },
                "error": function (XHR, textStatus, errorThrown) {

                    console.log("Error is : ",XHR);
                    const error = XHR.responseJSON;

                    notifyMe("error",error.message);
                }
            });

            $("#pdf-delete-modal").modal("hide");

            initFeather();
        }


        async function loadPdfChat(id){
            $('#vision_image').html(null);

            await $.ajax({
                "type": "GET",
                "url": "<?php echo e(route('pdfChat.index')); ?>?load_pdf_chat="+id,
                "success": function (response) {
                    console.log("Conversation is : ",response);
                    $(".convo123").html(response.data);
                },
                "error": function (XHR, textStatus, errorThrown) {
                    console.log("Error is : ",XHR);
                }
            });
        }

        $(document).on('submit', '#pdfChatForm', function (e) {
            e.preventDefault();

            var formData = new FormData();
            var promptValue = $('#prompt').val();
            var pdfFile = $('#pdfFile')[0].files[0];

            formData.append('prompt', promptValue);
            formData.append('pdfFile', pdfFile);
            formData.append('_token', "<?php echo e(csrf_token()); ?>");

            // Loader Assign.
            messageContainer.prepend(loadingLoader);

            $('#vision_image').html(null);

            try {
                $.ajax({
                    url: "<?php echo e(route('pdfChat.pdfChatEmbedding')); ?>",
                    type: 'POST',
                    data: formData,
                    processData: false,
                    contentType: false,
                    success: function (response) {

                        $('#prompt').val(null);
                        formData.append('prompt', null);
                        formData.append('pdfFile', null);

                        hideLoader();

                        console.log("Server Response is : ", response);

                        try{
                            let promptData = userInputDataMaker(promptValue, response.data);

                            // Loader Assign.
                            messageContainer.append(userHtmltSection(promptData))

                            messageContainer.append(loadingLoader);

                            initScrollToChatBottom();

                            chatCompletionEventSource();
                        }
                        catch (e) {
                            console.log("Embedding Error is Here : ",e);
                        }

                    }, // Success Close Here
                    error: function (XHR, textStatus, error) {
                        hideLoader();

                        const jsonData = JSON.parse(XHR.responseText);

                        console.log("Error Json Data : ", jsonData);

                        notifyMe("error", jsonData.message);

                        console.log("XHR Response is : ", XHR);
                        console.log("Error Status Response is : ", textStatus);
                        console.log("XHR Response is : ", XHR);
                        // Handle the error response here

                        const jsonResponse = jsonData;

                        // Display errors for all properties in the data object
                        displayErrors(jsonResponse.data);
                    }
                });
            } catch (e) {
                console.log("Catch Error : ", e)
            }

        });

        function hideLoader(){
            $(".mrLoader").addClass("d-none");
        }


        // Function to dynamically iterate over properties and display errors
        function displayErrors(data) {
            if (typeof data === 'object' && data !== null) {
                for (const key in data) {
                    const errors = data[key];
                    if (Array.isArray(errors) && errors.length > 0) {
                        console.log(`${key} Errors:`);
                        errors.forEach(error => {
                            console.log(error);
                            notifyMe('error', "Validation Error : "+error);
                        });
                    } else if (typeof data[key] === 'object') {
                        displayErrors(data[key]);
                    }
                }
            }
        }


        // Forcefully stop generating content
        $(document).on('click', '.btn-stop-content', function(e) {
            e.preventDefault();
            if (TT.eventSource) {
                TT.eventSource.close();
            }
            resetGenerateButton();
            notifyMe('info', '<?php echo e(localize('Ai Pdf Chat has been stopped.')); ?>');
        });

        function resetGenerateButton() {
            $('.new-msg-loader').first().removeClass('new-msg-loader');
            $('.msg-send-btn').prop('disabled', false);
            $('.btn-stop-content').prop('disabled', true);
            initFeather();
        }


        function chatCompletionEventSource() {
            /*
             * Pdf Chat Completion Start With Event Source
             * */

            let urlEvent = "<?php echo e(route('pdfChat.pdfChatCompletion')); ?>";

            console.log("urlEvent : ", urlEvent);

            TT.eventSource = new EventSource(`${urlEvent}`, {
                withCredentials: true
            });

            let finalText = '';

            messageContainer.append(outputHtmlSection(finalText));

            TT.eventSource.onmessage = function (e) {
               //  $(".mrLoader").addClass("d-none");
                hideLoader();

                console.log("Response From Chat Completion", e);

                if (e.data.indexOf("[DONE]") !== -1) {
                    // $('.new-msg-loader').first().removeClass('new-msg-loader');
                    $('.msg-send-btn').prop('disabled', false);
                    $('.btn-stop-content').prop('disabled', true);
                    TT.eventSource.close();
                } else {

                    $('.btn-stop-content').prop('disabled', false);
                    let txt = undefined;
                    try {
                        txt = JSON.parse(e.data).choices[0].delta.content;
                        if (txt !== undefined) {
                            console.log("Streaming Text is : ", txt);
                            let oldValue = '';

                            let value = oldValue + txt;
                            finalText = formatText(value);

                            initScrollToChatBottom();

                            sentence += finalText;

                           // let finalSentence = decodeHtmlEntities(sentence);
                            let finalSentence = sentence;

                            $(".outputText:last").html(finalSentence);

                            console.log("Output data Data Prepending", sentence);
                            initScrollToChatBottom();

                        }
                    } catch (e) {

                        notifyMe('error', "Catch Error : "+error);

                     //   notifyMe("error",e);
                        console.log("Failed to access Content : ", e);
                    }

                }

                initScrollToChatBottom();
            };

            TT.eventSource.onerror = function (e) {
                TT.eventSource.close();
            };

            /*
            * Pdf Chat Completion Start With Event Source
            * */
        }


        function decodeHtmlEntities(input) {
            var doc = new DOMParser().parseFromString(input, "text/html");
            return doc.documentElement.textContent;
        }

        function formatText(text) {
            return text.replace(/(?:\r\n|\r|\n)/g, '<br>');
        }

        $(()=>{
            $('#pdfFile').change(function () {
                let fileNameDisplay = $('#vision_image');
                let file = this.files[0];

                let pdfSvg = `<?php echo e(asset("public/backend/pdfChat/pdf-icon.svg")); ?>`;

                if (file) {
                    fileNameDisplay.html(`Selected PDF: ${file.name} <img src="${pdfSvg}" loading="lazy" alt="Icon Not Found." />`);
                } else {
                    fileNameDisplay.html('No PDF selected');
                }
            });
        })


        let userAvatar = '<?php echo e(userAvatar()); ?>';

        function userHtmltSection(inputText) {

            console.log("Avatar is : ", userAvatar);
            return `
                    <div class="d-flex justify-content-end mt-4 tt-message-wrap tt-message-me">
                        <div class="d-flex flex-column align-items-end">
                          <div class="d-flex align-items-start">
                            <div class="me-3 p-3 rounded-3 text-end mw-450 tt-message-text">
                                ${inputText}
                            </div>
                            <div class="avatar avatar-md flex-shrink-0">
                              <img
                                    loading="lazy"
                                    class="rounded-circle"
                                    src="${userAvatar}"
                                    alt=" avatar" />
                            </div>
                          </div>
                        </div>
                    </div>`;
        }

        function outputHtmlSection(outputText) {
            return `<div class="d-flex justify-content-start mt-4 tt-message-wrap outputConversationSection">
                            <div class="d-flex flex-column align-items-start">
                              <div class="d-flex align-items-start">
                                <div class="avatar avatar-md flex-shrink-0">
                                  <img
                                    loading="lazy"
                                    class="rounded-circle"
                                    src="<?php echo e(staticAsset('/backend/assets/img/avatar/1.jpg')); ?>"
                                    alt="avatar" />
                                </div>
                                <div class="ms-3 p-3 rounded-3 text-start mw-650 tt-message-text outputText">
                                    ${outputText}
                                </div>
                              </div>

                            </div>
                          </div>`;
        }


        const loadingLoader = `<div class="d-flex justify-content-start mt-4 tt-message-wrap mrLoader">
                            <div class="d-flex flex-column align-items-start">
                              <div class="d-flex align-items-start">
                                <div class="avatar avatar-md flex-shrink-0">
                                  <img
                                    class="rounded-circle"
                                    loading="lazy"
                                    src="<?php echo e(staticAsset('/backend/assets/img/avatar/1.jpg')); ?>"
                                    alt="avatar" />
                                </div>
                                <div class="ms-3 p-2 rounded-3 text-start mw-450 tt-message-text">
                                  <!-- text preloader start -->
                                  <div class="tt-text-preloader">
                                    <span></span>
                                    <span></span>
                                    <span></span>
                                  </div>
                                  <!-- text preloader end -->
                                </div>
                              </div>
                            </div>
                          </div>`;


        function userInputDataMaker(prompt, data) {
            //let pdfName = data.pdf_file ? data.pdf_file.split("/")[2] :  data.data.pdf_file.split("/")[2];
            let pdfName = data.pdf_file.split("/")[2];

            let pdfLink = `${basePath}/${data.pdf_file}`;

            let pdfSvg = `${basePath}/public/backend/pdfChat/pdf-icon.svg`;

            return `${prompt} </br>
                    <a href='${pdfLink}' target="_blank">
                        <img src="${pdfSvg}" alt="XYZ Online" />
                        ${pdfName}
                    </a>`;
        }
    </script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('backend.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\xampp\htdocs\ai\pinterai\resources\views/backend/pages/pdfChat/index.blade.php ENDPATH**/ ?>